//Note: Details of scilab software version and OS version used:
//Tested on OS: Ubuntu 14.04 LTS, 64 bit
//Scilab version: 5.5.0 (Tested on 64 bit version)
//Program Title: Classful addressing: To determine the Class,1st & last address of the class, Number of networks and Number of hosts in the networks from any given classful address.
clear ;
clc ;
ip1 =input('Enter the 1st part of ip : ')
ip2 =input('Enter the 2nd part of ip : ')
ip3 =input('Enter the 3rd part of ip : ')
ip4 =input('Enter the 4th part of ip : ')
printf ( "Dotted Decimal notation of the IP address is :− %d . %d . %d . %d\n" ,ip1,ip2,ip3,ip4) ;

q=ip1;
n=0;
i=0;
if (q >=0 & q < 127) then
    n=8;
    i=1;
    disp("The first byte is between 0 and 127. Therefore this is a Class A address.");
    printf ("Network id: %d " ,ip1) ;
    printf ("\nHost id: %d.%d.%d" ,ip2,ip3,ip4) ;
    printf ("\nStart address : 0.0.0.0");
    printf ("\nEnd address : 127.255.255.255");
elseif q==127 then
    n=8;
    i=1;
    printf ("Network id: %d " ,ip1) ;
    printf ("\nHost id: %d.%d.%d" ,ip2,ip3,ip4) ;
    disp("The first byte is 127. Therefore it is a Class A address. This is used for Loopback addresses.");
    printf ("\nStart address : 0.0.0.0");
    printf ("\nEnd address : 127.255.255.255");
elseif (q >=128 & q <=191) then
    n=16;
    i=2;
    disp("The first byte is between 128 and 191. Therefore this is a Class B address.");
    printf ("Network id: %d.%d" ,ip1,ip2) ;
    printf ("\nHost id: %d.%d" ,ip3,ip4) ;
    printf ("\nStart address : 128.0.0.0");
    printf ("\nEnd address : 191.255.255.255");
elseif ( q >=192 & q <=223) then
    n=24;
    i=3;
    disp("The first byte is between 192 and 223. Therefore this is a Class C address.");
    printf ("Network id: %d.%d.%d " ,ip1,ip2,ip3) ;
    printf ("\nHost id: %d",ip4) ;
    printf ("\nStart address : 192.0.0.0");
    printf ("\nEnd address : 223.255.255.255");
elseif ( q >=224 & q <=239) then
    disp("The first byte is between 224 and 239. Therefore this is a Class D address.");
    printf ("\nStart address : 224.0.0.0");
    printf ("\nEnd address : 239.255.255.255");
elseif (q >=240 & q <=255) then
    disp("The first byte is between 240 and 255. Therefore this is a Class E address.");
    printf ("\nStart address : 240.0.0.0");
    printf ("\nEnd address : 255.255.255.255");
end


if n~=0 then
    printf ("\nNumber of Networks %d" ,(2^(n-i))) ;
    printf ("\nNumber of Hosts %d" ,(2^(32-n))-2) ;
end


//INPUT
//
//Enter the 1st part of ip : 172
//Enter the 2nd part of ip : 16
//Enter the 3rd part of ip : 0
//Enter the 4th part of ip : 1
//
//OUTPUT
//
//Dotted Decimal notation of the IP address is :− 172 . 16 . 0 . 1
//The first byte is between 128 and 191. Therefore this is a Class B address.
//Network id: 172.16
//Host id: 0.1
//Start address : 128.0.0.0
//End address : 191.255.255.255
//Number of Networks 16384
//Number of Hosts 65534
//
